def perms_insert(perms, char_prev, char_next):
	prev_exist = False
	prev_index = 0
	next_exist = False
	next_index = 0

	# First check if either characters are already in a permutation
	for perm in perms:
		# Check if the prev char exists in the permutation set
		if perm.count(char_prev) != 0:
			prev_exist = True
			prev_index = perms.index(perm)
		# Check if the next char exists in the permutation set
		if perm.count(char_next) != 0:
			next_exist = True
			next_index = perms.index(perm)
		# Break out of the loop once both are found
		if prev_exist and next_exist:
			break

	# Neither exists
	if not prev_exist and not next_exist:
		# If both chars are the same, insert the character into the permutation set by itself
		if char_prev == char_next:
			perms.append(char_next)
		# Otherwise append the two characters together and insert into the permutation set
		else:
			perms.append(char_prev+char_next)

	# Only the prev char exists so append the next char to the end of the permutation with the prev char
	if prev_exist and not next_exist:
		new_perm = perms[prev_index] + char_next
		perms.remove(perms[prev_index])
		perms.append(new_perm)

	# Only the next char exists so append the prev char to the start of the permutation with the next char
	if not prev_exist and next_exist:
		new_perm = char_prev + perms[next_index]
		perms.remove(perms[next_index])
		perms.append(new_perm)

	# Both chars exist
	if prev_exist and next_exist:
		# Check if they are part of the same permutation, combine permutations if they are not
		if prev_index != next_index:
			str1 = perms[prev_index]
			str2 = perms[next_index]
			new_perm = str1 + str2
			perms.remove(str1)
			perms.remove(str2)
			perms.append(new_perm)

	return perms

if __name__ == '__main__':
	input_text = 'GAWGST OTJPNA VBPLKM YPSYVU CZSXGU HTNINR PCLSOI WMGREH \
				YPSYVU CZSXGU HIZIMP PCLSOI WMGREH YPSYVU CZSXGU IOQHFZ \
				QNHDPB XPRCVD YAMYSL CQOXQQ JJHBJB QNHDPB XPRCVD YAMYSL \
				DXYMTS KPVOVY RJXNJK XPRCVD ZSTKHE DXYMTS LHXQRK RJXNJK \
				XPRCVD ZSTKHE DUOMAQ MVHFYB SGCADV XLICWW ZGGKDH DECMIV \
				NTUZNJ SGCADV YEDYIC AYKTCN EVIUYW NTUZNJ TDJWZA YEDYIC \
				BOOVFQ EVIUYW NDBZZO TDJWZA YEFYIC BOOVFQ FFEEXG OQMPQL \
				TRAWLF YEDYIC BWFVBX FKLEUI OQMPQL UHAJRF YEDYIC BWFVBX \
				FYPECM'
	# Split the input into an array of 6 letter strings
	input_split = input_text.split();

	# Iterate and process through D*A, E*B, F*C
	for offset in range(3):
		perms = []
		# Go through each letter set and insert into permutation list
		for entry in input_split:
			perms = perms_insert(perms, entry[offset], entry[offset+3])
		print offset, offset+3, perms
